//
//  GraphicsViewControllerView.m
//  Adding Shadows to Shapes
//
//  Created by Vandad Nahavandipoor on 17/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "GraphicsViewControllerView.h"

@implementation GraphicsViewControllerView

- (id)initWithFrame:(CGRect)frame{
  self = [super initWithFrame:frame];
  if (self) {
    //  Miejsce na kod inicjalizacyjny.
  }
  return self;
}

/* 1 */
//- (void) drawRectAtTopOfScreen{
//  
//  /* Pobranie uchwytu do bieżącego kontekstu graficznego. */
//  CGContextRef currentContext = UIGraphicsGetCurrentContext();
//  
//  CGContextSetShadowWithColor(currentContext,
//                              CGSizeMake(10.0f, 10.0f),
//                              20.0f,
//                              [[UIColor grayColor] CGColor]);
//  
//  /* Najpierw tworzymy ścieżkę. Pobieramy po prostu uchwyt do ścieżki. */
//  CGMutablePathRef path = CGPathCreateMutable();
//  
//  /* To jest obszar ograniczający prostokąt. */
//  CGRect firstRect = CGRectMake(55.0f,
//                                60.0f,
//                                150.0f,
//                                150.0f);
//  
//  /* Dodanie prostokąta do ścieżki. */
//  CGPathAddRect(path,
//                NULL,
//                firstRect);
//  
//  /* Dodanie ścieżki do bieżącego kontekstu graficznego. */
//  CGContextAddPath(currentContext,
//                   path);
//  
//  /* Zdefiniowanie koloru wypełnienia: niebieski. */
//  [[UIColor colorWithRed:0.20f
//                   green:0.60f
//                    blue:0.80f
//                   alpha:1.0f] setFill];
//  
//  /* Wypełnienie ścieżki w kontekście graficznym. */
//  CGContextDrawPath(currentContext,
//                    kCGPathFill);
//  
//  /* Usunięcie ścieżki. */
//  CGPathRelease(path);
//  
//}
//
//- (void) drawRect:(CGRect)rect{
//  [self drawRectAtTopOfScreen];
//}

/* 2 */
//- (void) drawRectAtTopOfScreen{
//  
//  /* Pobranie uchwytu do bieżącego kontekstu graficznego. */
//  CGContextRef currentContext = UIGraphicsGetCurrentContext();
//  
//  CGContextSetShadowWithColor(currentContext,
//                              CGSizeMake(10.0f, 10.0f),
//                              20.0f,
//                              [[UIColor grayColor] CGColor]);
//  
//  /* Najpierw tworzymy ścieżkę. Pobieramy po prostu uchwyt do ścieżki. */
//  CGMutablePathRef path = CGPathCreateMutable();
//  
//  /* To jest obszar ograniczający prostokąt. */
//  CGRect firstRect = CGRectMake(55.0f,
//                                60.0f,
//                                150.0f,
//                                150.0f);
//  
//  /* Dodanie prostokąta do ścieżki. */
//  CGPathAddRect(path,
//                NULL,
//                firstRect);
//  
//  /* Dodanie ścieżki do bieżącego kontekstu graficznego. */
//  CGContextAddPath(currentContext,
//                   path);
//  
//  /* Zdefiniowanie koloru wypełnienia: niebieski. */
//  [[UIColor colorWithRed:0.20f
//                   green:0.60f
//                    blue:0.80f
//                   alpha:1.0f] setFill];
//  
//  /* Wypełnienie ścieżki w kontekście graficznym. */
//  CGContextDrawPath(currentContext,
//                    kCGPathFill);
//  
//  /* Usunięcie ścieżki. */
//  CGPathRelease(path);
//  
//}
//
//- (void) drawRectAtBottomOfScreen{
//  
//  /* Pobranie uchwytu do bieżącego kontekstu graficznego. */
//  CGContextRef currentContext = UIGraphicsGetCurrentContext();
//  
//  CGMutablePathRef secondPath = CGPathCreateMutable();
//  
//  CGRect secondRect = CGRectMake(150.0f,
//                                 250.0f,
//                                 100.0f,
//                                 100.0f);
//  CGPathAddRect(secondPath,
//                NULL,
//                secondRect);
//  
//  CGContextAddPath(currentContext,
//                   secondPath);
//  
//  [[UIColor purpleColor] setFill];
//  
//  CGContextDrawPath(currentContext,
//                    kCGPathFill);
//  
//  CGPathRelease(secondPath);
//  
//}
//
//- (void)drawRect:(CGRect)rect{
//  [self drawRectAtTopOfScreen];
//  [self drawRectAtBottomOfScreen];
//}

/* 3 */
- (void) drawRectAtTopOfScreen{
  
  /* Pobranie uchwytu do bieżącego kontekstu graficznego. */
  CGContextRef currentContext = UIGraphicsGetCurrentContext();
  
  CGContextSaveGState(currentContext);
  
  CGContextSetShadowWithColor(currentContext,
                              CGSizeMake(10.0f, 10.0f),
                              20.0f,
                              [[UIColor grayColor] CGColor]);
  
  /* Najpierw tworzymy ścieżkę. Pobieramy po prostu uchwyt do ścieżki. */
  CGMutablePathRef path = CGPathCreateMutable();
  
  /* To jest obszar ograniczający prostokąt. */
  CGRect firstRect = CGRectMake(55.0f,
                                60.0f,
                                150.0f,
                                150.0f);
  
  /* Dodanie prostokąta do ścieżki. */
  CGPathAddRect(path,
                NULL,
                firstRect);
  
  /* Dodanie ścieżki do bieżącego kontekstu graficznego. */
  CGContextAddPath(currentContext,
                   path);
  
  /* Zdefiniowanie koloru wypełnienia: niebieski. */
  [[UIColor colorWithRed:0.20f
                   green:0.60f
                    blue:0.80f
                   alpha:1.0f] setFill];
  
  /* Wypełnienie ścieżki w kontekście graficznym. */
  CGContextDrawPath(currentContext,
                    kCGPathFill);
  
  /* Usunięcie ścieżki. */
  CGPathRelease(path);
  
  /* Przywrócenie kontekstu graficznego. */
  CGContextRestoreGState(currentContext);
  
}

- (void) drawRectAtBottomOfScreen{
  
  /* Pobranie uchwytu do bieżącego kontekstu graficznego. */
  CGContextRef currentContext = UIGraphicsGetCurrentContext();
  
  CGMutablePathRef secondPath = CGPathCreateMutable();
  
  CGRect secondRect = CGRectMake(150.0f,
                                 250.0f,
                                 100.0f,
                                 100.0f);
  CGPathAddRect(secondPath,
                NULL,
                secondRect);
  
  CGContextAddPath(currentContext,
                   secondPath);
  
  [[UIColor purpleColor] setFill];
  
  CGContextDrawPath(currentContext,
                    kCGPathFill);
  
  CGPathRelease(secondPath);
  
}

- (void)drawRect:(CGRect)rect{
  [self drawRectAtTopOfScreen];
  [self drawRectAtBottomOfScreen];
}

@end
